// TODO this file was just too much for linting at this time
/* eslint-disable vars-on-top,max-len,no-magic-numbers,no-mixed-operators,no-useless-escape */
// answer is saved on 'value' of this.model, can then _.pluck value from each model in the collection
define([
    'underscore',
    'backbone',
    'marionette',
    'moment',
    'jquery.validate.config',
    'jquery.mask',
    'datepicker',
    'json!modules/form/weekdays-en.json',
    'text!modules/form/input/_checkbox-radio-group.html',
    'text!modules/form/input/_radio-toggle.html',
    'text!modules/form/input/_slider.html',
    'text!modules/form/input/_select-menu.html',

    'text!modules/form/input/_text.html',
    'text!modules/form/input/_number.html',
    'text!modules/form/input/_textarea.html',
    'text!modules/form/input/_datepicker.html',

    'text!modules/form/input/_button.html',
    'text!modules/form/input/_static.html',
], function(
    _,
    Backbone,
    Marionette,
    moment,
    jQueryValidateConfig,
    mask,
    datepicker,
    weekdays,
    checkboxRadioTemplate,
    radioToggleTemplate,
    sliderTemplate,
    selectMenuTemplate,
    textTemplate,
    numberTemplate,
    textareaTemplate,
    datepickerTemplate,
    buttonTemplate,
    staticTemplate
) {
    'use strict';

    return Backbone.Marionette.View.extend({
        template: staticTemplate,

        // eslint-disable-next-line complexity
        initialize: function(options) {
            var initialOptions = _.extend({}, options, {type: this.model.get('type') || 'static'});
            var type = initialOptions.type;

            this.className = this.model.get('className');

            switch (type) {
            case 'checkbox':
                /* falls through */
            case 'radio':
                /* falls through */
            case 'toggle':
                this.initializeCheckboxRadio();
                break;
            case 'range-slider':
                this.initializeSlider();
                break;
            case 'select':
                this.initializeSelectMenu();
                break;
            case 'tel':
                this.initializeTel();
                break;
            case 'email':
                /* falls through */
            case 'text':
                this.initializeText();
                break;
            case 'number':
                this.initializeNumber();
                break;
            case 'textarea':
                this.initializeTextarea();
                break;
            case 'text-datepicker':
                this.initializeDatepicker();
                break;
            case 'button':
                this.initializeButton();
                break;
            case 'static':
                /* falls through */
            default:
                this.initializeStatic();
                break;
            }
            this.delegateEvents();
        },
        initializeCheckboxRadio: function() {
            this.model.set('name', this.model.get('idPrefix') + this.model.get('id'));
            this.collection = new Backbone.Collection(this.model.get('values'));

            _.extend(this, {
                template: (this.model.get('type') !== 'toggle') ? checkboxRadioTemplate : radioToggleTemplate,
                events: {
                    'change input[type=radio]': 'setValue',
                    'click input[type=checkbox]': 'setValue',
                },
                serializeData: function() {
                    var data = (this.model) ? this.model.toJSON() : {};

                    // overwrite any property named items
                    if (this.collection) {
                        _.extend(data, { items: this.collection.toJSON() });
                    }

                    return data;
                },
                getModelByValue: function(value) {
                    return _.find(this.collection.models, function(model) {
                        return model.get('value') === value;
                    });
                },
                setValue: function(e) {
                    // ensure value is within this.collection
                    var model = this.getModelByValue($(e.currentTarget).val());

                    var value;

                    if (!_.isUndefined(model)) {
                        value = model.get('value');
                    } else if ($(e.currentTarget).val() === 'true') {
                        value = this.getModelByValue(true).get('value');
                    } else if ($(e.currentTarget).val() === 'false') {
                        value = this.getModelByValue(false).get('value');
                    }

                    this.model.set('value', value);
                    this.model.set('selected', e.currentTarget.checked);
                },
                onDomRefresh: function() {
                    var name = this.model.get('name');

                    this.$el.trigger('create');
                    this.addFormValidationRules(
                        this.model.get('legend').replace(/\:\s?/, ''),
                        this.$el.find('input[name="' + this.model.get('name') + '"]')
                    );

                    // on IE the handlebar setting of checked does not work
                    if (name) {
                        this.$el.find('input[type="radio"][name="' + name + '"][checked="checked"]')
                            .prop('checked', true);
                    }
                },
            });
        },
        initializeSlider: function() {
            _.extend(this, {
                template: sliderTemplate,
                events: {
                    'change input': 'setValue',
                    'blur input': 'setValue',
                    'tap a.ui-slider-handle': 'doNothing',
                    'click a.ui-slider-handle': 'doNothing',
                },
                // jquery puts a href='#' on the link elements it inserts on sliders
                // which caused iOS to do very bad things, like delete objects, so we make it do nothing
                doNothing: function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    return false;
                },
                setValue: function(e) {
                    var value = parseInt(this.$el.find('input').val(), 10);
                    // Backbone handles triggering change event only when value has changed
                    this.model.set('value', value);
                },
                insertSliderNumbers: function() {
                    if (this.$el.find('.ui-slider-track-label').length === 0) {
                        var $sliderTrackLabel = $('<div class="ui-slider-track-label"></div>');
                        var min = this.model.get('min');
                        var max = this.model.get('max');

                        this.$el.find('.ui-slider-track').before($sliderTrackLabel);

                        $sliderTrackLabel.append('<span class="ui-slider-track-label-left">' + min + '</span>');
                        if ((max - min + 1) % 2 === 1) {
                            // show number in center
                            $sliderTrackLabel.append('<span class="ui-slider-track-label-center">' + ((max - min) / 2 + min) + '</span>');
                        }
                        $sliderTrackLabel.append('<span class="ui-slider-track-label-right">' + max + '</span>');
                    }
                },
                onDomRefresh: function() {
                    this.$el.trigger('create');
                    this.addFormValidationRules(
                        this.model.get('label').replace(/\:\s?/, ''),
                        this.$el.find('input[type="range"]')
                    );

                    this.insertSliderNumbers();
                },
            });
        },
        initializeSelectMenu: function() {
            this.collection = new Backbone.Collection(this.model.get('values'));

            _.extend(this, {
                template: selectMenuTemplate,
                events: {
                    // NOTE: value 'updateButtonText setValue' not working
                    'change select': 'setValue',
                    'focus select': 'handleInputFocus',
                    'blur select': 'handleInputBlur',
                },
                serializeData: function() {
                    var data = (this.model) ? this.model.toJSON() : {};

                    // overwrite any property named items
                    if (this.collection) {
                        _.extend(data, { items: this.collection.toJSON() });
                    }

                    return data;
                },
                getModelByValue: function(value) {
                    return _.find(this.collection.models, function(model) {
                        return model.get('value') === value;
                    });
                },
                setValue: function(e) {
                    // ensure value is within this.collection
                    var validModel = this.getModelByValue($(e.currentTarget).val());

                    if (validModel) {
                        this.model.set('value', validModel.get('value'));
                    } else /* option "Select..." with value === "" selected */ {
                        this.model.unset('value');
                    }
                },
                // from jquery mobile
                handleInputFocus: function(e) {
                    $(e.currentTarget).addClass($.mobile.focusClass);
                },
                handleInputBlur: function(e) {
                    $(e.currentTarget).removeClass($.mobile.focusClass);
                },
                onDomRefresh: function() {
                    this.addFormValidationRules(
                        this.model.get('label').replace(/\:\s?/, ''),
                        this.$el.find('select')
                    );
                },
            });
        },
        initializeTel: function() {
            this.initializeText();
            _.extend(this,
                {
                    maskInput: function() {
                        this.$el.find('input[type="tel"]').mask('(000) 000-0000');
                    },
                    unmaskInput: function() {
                        this.$el.find('input[type="tel"]').unmask();
                    },
                    onDomRefresh: function() {
                        this.$el.trigger('create');
                        this.addFormValidationRules(
                            this.model.get('label').replace(/\:\s?/, ''),
                            this.$el.find('input[type="' + this.model.get('type') + '"]')
                        );
                        this.maskInput();
                    },
                    onBeforeDestroy: function() {
                        this.unmaskInput();
                    },
                }
            );
        },
        initializeText: function() {
            _.extend(this,
                {
                    template: textTemplate,
                    events: {
                        'change input': 'setValue',
                        'blur input': 'setValue',
                    },
                    setValue: function(e) {
                        var value = this.$el.find('input').val()
                            .trim();
                        // Backbone handles triggering change event only when value has changed
                        this.model.set('value', value);
                    },
                    onDomRefresh: function() {
                        this.$el.trigger('create');
                        this.addFormValidationRules(
                            this.model.get('label').replace(/\:\s?/, ''),
                            this.$el.find('input[type="' + this.model.get('type') + '"]')
                        );
                    },
                }
            );
        },
        initializeNumber: function() {
            _.extend(this,
                {
                    template: numberTemplate,
                    events: {
                        'change input': 'setValue',
                        'blur input': 'setValue',
                    },
                    setValue: function(e) {
                        var value = this.$el.find('input').val()
                            .trim();
                        // Backbone handles triggering change event only when value has changed
                        this.model.set('value', value);
                    },
                    onDomRefresh: function() {
                        this.$el.trigger('create');
                        this.addFormValidationRules(
                            this.model.get('label').replace(/\:\s?/, ''),
                            this.$el.find('input[type="number"]')
                        );
                    },
                }
            );
        },
        initializeTextarea: function() {
            _.extend(this, {
                template: textareaTemplate,
                events: {
                    'change textarea': 'setValue',
                    'blur textarea': 'setValue',
                    'keyup textarea': 'updateCounter',
                    'onchange textarea': 'updateCounter',
                    'onpaste textarea': 'updateCounter',
                },
                setValue: function(e) {
                    var value = this.$el.find('textarea').val()
                        .trim();
                    // Backbone handles triggering change event only when value has changed
                    this.model.set('value', value);
                },
                getValWithCarriageReturns: function(el) {
                    // jQuery's $.val() strips carriage returns from count
                    return el ? el.value.replace(/\r(?!\n)|\n(?!\r)/g, '\r\n') : '';
                },
                updateCounter: function(e) {
                    // update counter AND enforce the limit set by maxlength since IE does not honor maxlength
                    var $textarea = this.$el.find('textarea');
                    if ($textarea.length > 0) {
                        var maxLength = $textarea.attr('maxlength');
                        var val = this.getValWithCarriageReturns($textarea.get(0));
                        if (val.length > maxLength) {
                            $textarea.val(val.substring(0, maxLength));
                        }
                        this.$el.find('.textarea-counter').html((maxLength <= val.length ? 0 : (maxLength - val.length)) + ' characters remaining');
                    }
                },
                onRender: function() {
                    this.updateAttributesAndClassName();
                    this.updateCounter();
                },
                onDomRefresh: function() {
                    this.$el.trigger('create');
                    this.addFormValidationRules(
                        this.model.get('label').replace(/\:\s?/, ''),
                        this.$el.find('textarea')
                    );
                },
            });
        },
        initializeDatepicker: function() {
            // initialize model value and placeholder
            if (this.model.get('value') === 'today') {
                var dateToday = new Date();
                this.model.set('value', dateToday);
            }
            var placeholder = this.model.get('placeholder');
            if (_.isUndefined(placeholder) || placeholder === '') {
                this.model.set('placeholder', 'MM/DD/YYYY');
            }

            var inlineClassName = 'form-input-datepicker';
            _.extend(this,
                {
                    className: (this.model.has('className') ? this.model.get('className') + ' ' + inlineClassName : inlineClassName),
                    template: datepickerTemplate,
                    modelEvents: {'change:value': 'updateDayOfWeekSpan'},
                    onDomRefresh: function() {
                        this.createDatepicker();
                    },
                    onBeforeDestroy: function() {
                        this.destroyDatepicker();
                    },

                    // eslint-disable-next-line complexity
                    createDatepicker: function() {
                        // defaults
                        var options = {
                            autoclose: true,
                            container: this.$el,
                            orientation: 'bottom left',
                        };

                        if (this.model.has('MIN')) {
                            options.startDate = this.model.get('MIN') === 'today' ? new Date() : new Date(this.model.get('MIN'));
                        } else if (this.model.has('min')) {
                            options.startDate = this.model.get('min') === 'today' ? new Date() : new Date(this.model.get('min'));
                        }
                        if (this.model.has('MAX')) {
                            options.endDate = this.model.get('MAX') === 'today' ? new Date() : new Date(this.model.get('MAX'));
                        } else if (this.model.has('max')) {
                            options.endDate = this.model.get('max') === 'today' ? new Date() : new Date(this.model.get('max'));
                        }

                        var $dateInput = this.$el.find('input[type="text"]');
                        var $datepickerBtn = this.$el.find('button');
                        this.$el.trigger('create');

                        // mask input and checking of validation rules on keyup events
                        // to trigger before changeDate and keyup.updatedatepicker
                        this.maskInput();
                        this.addFormValidationRules(options.startDate, options.endDate);

                        $datepickerBtn.datepicker(options)
                            .on('changeDate', function(e) {
                                $dateInput.val(e.format());
                                // picked date is e.date
                                this.model.set('value', e.date);
                                if ($dateInput.valid()) {
                                    this.validateOtherInputs(e, $dateInput);
                                    this.updateDayOfWeekSpan();
                                } else {
                                    // unsetting this value would default it to today so set it to empty so clicking previous then forward removes any invalid date.
                                    this.deleteDayOfWeekSpan();
                                }
                            }.bind(this))
                            .on('hide', function(e) {
                                setTimeout(function() {
                                    $datepickerBtn.blur();
                                    $dateInput.focus();
                                }, 250);
                            });
                        $dateInput.on('keyup.updatedatepicker', function(e) {
                            var dateString = $(e.currentTarget).val();
                            if (dateString === '' || dateString.length < 10 || (this.model.has('validate') && !$dateInput.valid())) {
                                this.model.set('value', '');
                                $datepickerBtn.datepicker('update', '');
                            } else {
                                this.validateOtherInputs(e, $dateInput);
                                this.model.set('value', new Date(dateString));
                                $datepickerBtn.datepicker('update', dateString);
                            }
                        }.bind(this));
                    },
                    validateOtherInputs: function(e, $dateInput) {

                        var otherUniqueDateInputs = '.' + inlineClassName + ' :text:not(#' + $dateInput.attr('id') + ')';
                        $(otherUniqueDateInputs).each(function(index, otherInput) {
                            var $otherInput = $(otherInput);
                            if ($otherInput.val()) {
                                $otherInput.valid();
                            }
                        });

                    },
                    destroyDatepicker: function() {
                        var $dateInput = this.$el.find('input[type="text"]');
                        var $datepickerBtn = this.$el.find('button');

                        $datepickerBtn.datepicker('destroy');
                        $dateInput.off('change.updatedatepicker');
                        this.unmaskInput();
                    },
                    maskInput: function() {
                        this.$el.find('input[type="text"]').mask('00/00/0000');
                    },
                    unmaskInput: function() {
                        this.$el.find('input[type="text"]').unmask();
                    },
                    addFormValidationRules: function(startDate, endDate) {
                        if (this.$el.closest('form').length === 1) {
                            var rules = {};

                            if (this.model.get('required')) {
                                rules.required = this.model.get('required');
                                rules.messages = {required: this.model.get('label').replace(/\:\s?/, '') + ' field is required.'};
                            }

                            if ((this.model.has('validate') && !_.isUndefined(this.model.get('validate').rules))) {
                                rules = _.extend(rules, this.model.get('validate').rules);

                                if (rules.dateInRange) {
                                    rules.dateInRange = [
                                        moment(startDate).format('MM/DD/YYYY'),
                                        moment(endDate).format('MM/DD/YYYY'),
                                    ];
                                }
                            }

                            this.$el.find('input[type="text"]').rules('add', rules);
                        }
                    },
                    updateDayOfWeekSpan: function() {
                        var getDayOfWeek = function() {
                            var date = this.model.get('value');
                            var dayOfWeek = '';

                            if (date) {
                                dayOfWeek = weekdays.days[date.getDay()];
                            }

                            return dayOfWeek;
                        }.bind(this);

                        var dayOfWeek = getDayOfWeek();

                        var $dayOfWeek = this.$el.find('.form-input-datepicker-day');
                        this.deleteDayOfWeekSpan();
                        if (dayOfWeek !== '') {
                            $dayOfWeek.find('.ui-hidden-accessible').append(weekdays.prefix + dayOfWeek);
                            $dayOfWeek.find('[role="presentation"]').append(dayOfWeek);
                        }
                    },
                    deleteDayOfWeekSpan: function() {
                        var $dayOfWeek = this.$el.find('.form-input-datepicker-day');
                        $dayOfWeek.find('.ui-hidden-accessible').empty();
                        $dayOfWeek.find('[role="presentation"]').empty();
                    },
                    templateContext: function() {
                        return {descriptionText: _.template(this.model.get('descriptionTemplate'))(this.serializeData())};
                    },
                }
            );
        },
        initializeButton: function() {
            _.extend(this, {
                template: buttonTemplate,
                events: {
                    'tap [role=button]:not([aria-disabled=true])': 'fireEvent',
                    'keydown [role=button]:not([aria-disabled=true])': function(e) {
                        if (e.which === 13 /* Enter */) {
                            this.fireEvent(e);
                        }
                    },
                },
                fireEvent: function(e) {
                    e.preventDefault();
                    this.trigger(this.model.get('event'));
                },
            });
        },
        initializeStatic: function() {
            var templateDefined = this.model.get('template');
            _.extend(this,
                {
                    template: (templateDefined) ? templateDefined : staticTemplate,
                    setValue: function(e) {
                        // TODO this function was broke so i delete it
                    },
                }
            );

            this.setValue();
        },
        onRender: function() {
            this.updateAttributesAndClassName();
        },
        setAttributes: function(attrs) {
            for (var key in attrs) {
                if (attrs.hasOwnProperty(key)) {
                    this.el.setAttribute(key, attrs[key]);
                }
            }
        },
        updateAttributesAndClassName: function() {
            // apply attributes and className that have been set post-initialize
            if (this.attributes) {
                this.setAttributes(this.attributes);
            }
            if (this.className) {
                this.el.className = this.className;
            }
        },
        onDomRefresh: function() {
            this.$el.trigger('create');
        },
        addFormValidationRules: function(fieldName, $input) {
            if (this.$el.closest('form').length === 1) {
                var rules = {};

                if (this.model.get('required')) {
                    rules.required = this.model.get('required');
                    rules.messages = {required: fieldName + ' field is required.'};
                }

                if (this.model.has('validate') && !_.isUndefined(this.model.get('validate').rules)) {
                    rules = _.extend(rules, this.model.get('validate').rules);

                }
                if (!_.isEmpty(rules)) {
                    $input.rules('add', rules);
                }
            }
        },
    });
});
